#include <iostream>
#include <vector>
#include <cmath>
using namespace std;

bool check(double x, int mi, int ai, int li, int ri, vector<double>& a) {
    double size = x * mi;
    if (size < li || size > ri) return false;
    for (int i = 0; i < a.size(); i++) {
        size += x * a[i];
        if (size < li || size > ri) return false;
    }
    return true;
}

double solve(int N, int S, int li, int ri, vector<double>& a) {
    double left = 0, right = 1e18;
    while (right - left > 1e-6) {
        double mid = (left + right) / 2;
        if (check(mid, S, a[0], li, ri, a)) left = mid;
        else right = mid;
    }
    return left;
}

int main() {
    int T;
    cin >> T;
    while (T--) {
        int N, S, li, ri;
        cin >> N >> S >> li >> ri;
        vector<double> a(N);
        for (int i = 0; i < N; i++) cin >> a[i];
        cout << (solve(N, S, li, ri, a) >= li && solve(N, S, li, ri, a) <= ri ? to_string(solve(N, S, li, ri, a)) : "nemoguce") << endl;
    }
    return 0;
}